<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreBlogRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return user()->can('blog-add');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'title' => 'required|string|max:255|unique:blogs,title',
            'content' => 'required|string',
            'category_id' => 'required|exists:categories,id',
            'destination_id' => 'nullable|exists:destinations,id',
            'status' => 'nullable|boolean',
            'thumbnail' => 'nullable|image|mimes:jpeg,png,jpg|max:1024',
        ];
    }
}
